<?php
require_once __DIR__ . '/../controllers/invoiceController.php';
$url = $_SERVER['REQUEST_URI'];
$method = $_SERVER['REQUEST_METHOD'];
$path = trim(parse_url($url, PHP_URL_PATH), "/");
$parts = explode("/", $path);
// POST /invoice
if ($method === 'POST' && end($parts) === 'invoice') {
    $params = json_decode(file_get_contents("php://input"), true);
    $invoiceController = new InvoiceController();
    $invoiceController->params = $params;
    $invoiceController->create();
}
elseif ($method === 'GET' && count($parts) > 3) {
    $invoice    = array_slice($parts, -3, 1)[0]; // "invoice"
    $prev       = array_slice($parts, -2, 1)[0]; //
    $last       = array_slice($parts, -1)[0];    // 
    // GET /invoice/{id}/{format}
    if ($invoice === 'invoice' && !empty($prev) && in_array($last, ['pdf', 'xml'])) {
      $invoiceController = new InvoiceController();
      $invoiceController->cfdi_id = $prev;
      $invoiceController->cfdi_format = $last;
      $invoiceController->getCfdiByFormat();
    }
    // GET ACUSE OF CANCEL /invoice/acuse/{id}
    if ($invoice === 'invoice' && !empty($prev) && $prev == "acuse" && !empty($last)) {
      $invoiceController = new InvoiceController();
      $invoiceController->cfdi_id = $last;
      $invoiceController->getCfdiAcuse();
    }
   
}
// DELETE CANCEL OF CFDI /invoice/cancel/{id}
elseif ($method === "DELETE" && count($parts) > 3) {
    $invoice    = array_slice($parts, -3, 1)[0]; // "invoice"
    $prev       = array_slice($parts, -2, 1)[0]; // 
    $last       = array_slice($parts, -1)[0];    // 
    if ($invoice === 'invoice' && !empty($prev) && $prev == "cancel" && !empty($last)) {
      $params = json_decode(file_get_contents("php://input"), true);
      $invoiceController = new InvoiceController();
      $invoiceController->cfdi_id = $last;
      $invoiceController->params = $params;
      $invoiceController->cancelCfdi();
    }
}
exit;
